package org.msh.tb.bd.tbforms.dhis2.schedule.scheduler;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.annotations.async.Expiration;
import org.jboss.seam.annotations.async.IntervalCron;
import org.jboss.seam.async.QuartzTriggerHandle;
import org.msh.tb.bd.tbforms.dhis2.schedule.asynctask.DHIS2ExportTB11ScheduleAsyncTask;

import java.util.Date;

/**
 * Created by mauri on 05/01/2018.
 */
@AutoCreate
@Name("dHIS2TB11ExportationScheduler")
@Scope(ScopeType.APPLICATION)
public class DHIS2TB11ExportationScheduler extends DHIS2ExportationScheduler {

    @Override
    @Asynchronous
    @Transactional
    public QuartzTriggerHandle createQuartzTimer(
            @Expiration Date when, @IntervalCron String interval) {

        // start TB 10 exportation
        taskManager.runTask(DHIS2ExportTB11ScheduleAsyncTask.class, getParams());

        return null;
    }
}
